#ifndef MISC_H
#define MISC_H

#include <iostream>
#include <cmath>
#include <fstream>
#include <string>
#include <cstring>
#include <cstdlib>
#include <iomanip>
#include <sstream>
#include <cfloat>
#include <vector>

#ifndef SKELGIS_H
#include "../libskelgis/skelgis.h"
#endif

#include "../libskelgis/chronometer.hpp"

#define max(a,b) (a>=b?a:b)
#define min(a,b) (a<=b?a:b)
#define grav 9.81
#define grav_dem 4.905

#define he_ca 1.e-6
#define ve_ca 1.e-6

#define NB_CHAR 256
#define zero 0.
#define Ie_ca 1.e-8
#define Ic_max 1.e-3
#define epsilon 1.e-10
# define version "FullSWOF_2D - version v1.01.00 - October, 6, 2011"
/*NB_CHAR is the maximum length of a comment line */

using namespace std;

typedef double SCALAR;
typedef DMatrix<SCALAR> * TAB;
typedef vector<TAB> vTAB;
typedef DMatrix<SCALAR>::iterator iTAB;

#endif

