#ifndef ORDER1_PARALLEL_H
#define ORDER1_PARALLEL_H

#include "order1.hpp"

//INIT DELZ1
//-------------------------------------------------------------------------------
BEGINApplyOneMat(order1_delz1_f,z,SCALAR,delz1,SCALAR)
//-------------------------------------------------------------------------------
{
    iTAB it_z = z->begin();
    iTAB it_del = delz1->begin();

    SCALAR delz1temp;

    unsigned int width = z->getWidth();
    unsigned int height = z->getHeight();

    for(int j=0; j<height; j++) {
        for(int i=0; i<width; i++) {
            delz1temp = z->getValue(it_z) - z->getLeftNeighbor(it_z);
            delz1->setValue(delz1temp,it_del);
            ++it_z;
            ++it_del;
        }
        //at width-1
        //On veut rester sur le z précédent
        --it_z;
        delz1temp = z->getRightNeighbor(it_z) - z->getValue(it_z);
        delz1->setValue(delz1temp,it_del);
        ++it_del;
        ++it_z;
    }
}
END(order1_delz1_f);
//-------------------------------------------------------------------------------

//INIT DELZ2
//-------------------------------------------------------------------------------
BEGINApplyOneMat(order1_delz2_f,z,SCALAR,delz2,SCALAR)
//-------------------------------------------------------------------------------
{
    iTAB it_z = z->begin();
    iTAB it_del = delz2->begin();
    iTAB it_zEnd = z->end();

    SCALAR delz2temp;

    for(; it_z<=it_zEnd; ++it_del,++it_z) {
        delz2temp = z->getUpNeighbor(it_z) - z->getValue(it_z);
        delz2->setValue(delz2temp,it_del);

    }
    iTAB it_delEnd = delz2->end();
    for(; it_delEnd>=it_del; --it_delEnd,--it_zEnd) {
        delz2temp = z->getValue(it_zEnd) - z->getDownNeighbor(it_zEnd);
        delz2->setValue(delz2temp,it_delEnd);
    }
}
END(order1_delz2_f);
//-------------------------------------------------------------------------------

//CACUL huv1
//-------------------------------------------------------------------------------
BEGINApplyList(order1_huv1_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h1l = outputs[0];//1
    TAB h1r = outputs[1];//1
    TAB u1l = outputs[2];//1
    TAB u1r = outputs[3];//1
    TAB v1l = outputs[4];//1
    TAB v1r = outputs[5];//1
    TAB h = inputs[0];//2
    TAB u = inputs[1];//2
    TAB v = inputs[2];//2

    iTAB it_2 = h->begin();
    iTAB it_0 = h1l->begin();

    unsigned int width = h->getWidth();
    unsigned int height = h->getHeight();

    for(int j=0; j<height; j++) {
        for(int i=0; i<width; i++) {
            h1r->setValue(h->getValue(it_2),it_0);
            u1r->setValue(u->getValue(it_2),it_0);
            v1r->setValue(v->getValue(it_2),it_0);

            h1l->setValue(h->getLeftNeighbor(it_2),it_0);
            u1l->setValue(u->getLeftNeighbor(it_2),it_0);
            v1l->setValue(v->getLeftNeighbor(it_2),it_0);

            ++it_2;
            ++it_0;
        }
        //at width-1
        --it_2;
        h1r->setValue(h->getRightNeighbor(it_2),it_0);
        u1r->setValue(u->getRightNeighbor(it_2),it_0);
        v1r->setValue(v->getRightNeighbor(it_2),it_0);
        h1l->setValue(h->getValue(it_2),it_0);
        u1l->setValue(u->getValue(it_2),it_0);
        v1l->setValue(v->getValue(it_2),it_0);
        ++it_2;
        ++it_0;
    }
}
END(order1_huv1_f);
//-------------------------------------------------------------------------------

//CACUL huv2
//-------------------------------------------------------------------------------
BEGINApplyList(order1_huv2_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h2l = outputs[0];//1
    TAB h2r = outputs[1];//1
    TAB u2l = outputs[2];//1
    TAB u2r = outputs[3];//1
    TAB v2l = outputs[4];//1
    TAB v2r = outputs[5];//1
    TAB h = inputs[0];//2
    TAB u = inputs[1];//2
    TAB v = inputs[2];//2

    iTAB it_2 = h->begin();
    iTAB it_1 = h2l->begin();
    iTAB it_hEnd = h->end();

    for(; it_2<=it_hEnd; ++it_2,++it_1) {
        h2l->setValue(h->getValue(it_2),it_1);
        u2l->setValue(u->getValue(it_2),it_1);
        v2l->setValue(v->getValue(it_2),it_1);

        h2r->setValue(h->getUpNeighbor(it_2),it_1);
        u2r->setValue(u->getUpNeighbor(it_2),it_1);
        v2r->setValue(v->getUpNeighbor(it_2),it_1);
    }

    iTAB it_1End = h2l->end();
    for(; it_1End>=it_1; --it_1End,--it_hEnd) {
        h2r->setValue(h->getValue(it_hEnd),it_1End);
        u2r->setValue(u->getValue(it_hEnd),it_1End);
        v2r->setValue(v->getValue(it_hEnd),it_1End);

        h2l->setValue(h->getDownNeighbor(it_hEnd),it_1End);
        u2l->setValue(u->getDownNeighbor(it_hEnd),it_1End);
        v2l->setValue(v->getDownNeighbor(it_hEnd),it_1End);
    }
}
END(order1_huv2_f);
//-------------------------------------------------------------------------------

#endif
