#ifndef ORDER2_PARALLEL_H
#define ORDER2_PARALLEL_H

#include "order2.hpp"

//INIT DELZ
//-------------------------------------------------------------------------------
BEGINApplyTwoMat(order2_delz_f,zl,SCALAR,zr,SCALAR,delz,SCALAR)
//-------------------------------------------------------------------------------
{

    iTAB it = delz->begin();
    iTAB it_End = delz->end();

    SCALAR delztemp;

    for(; it<=it_End; ++it) {
        delztemp = zr->getValue(it) - zl->getValue(it);
        delz->setValue(delztemp,it);
    }
}
END(order2_delz_f);

//INIT DELZC1
//-------------------------------------------------------------------------------
BEGINApplyTwoMat(order2_delzc1_f,zl,SCALAR,zr,SCALAR,delzc1,SCALAR)
//-------------------------------------------------------------------------------
{

    unsigned int width = delzc1->getWidth();
    unsigned int height = delzc1->getHeight();
    SCALAR delzc1temp;
    //initialisation iterateurs
    iTAB itc = delzc1->begin();
    iTAB itl = zl->begin();
    iTAB itr = zr->begin();
    ++itr;

    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            delzc1temp = zr->getValue(itr)-zl->getValue(itl);
            delzc1->setValue(delzc1temp,itc);
            //increment iterateurs
            ++itc;
            ++itl;
            ++itr;
        }
        //re-init left and right iterators
        ++itl;
        ++itr;
    }
}
END(order2_delzc1_f);
//-------------------------------------------------------------------------------

//-------------------------------------------------------------------------------
BEGINApplyTwoMat(order2_delzc2_f,zl,SCALAR,zr,SCALAR,delzc2,SCALAR)
//-------------------------------------------------------------------------------
{

    unsigned int width = delzc2->getWidth();
    unsigned int height = delzc2->getHeight();
    SCALAR delzc2temp;
    //initialisation iterateurs
    iTAB itc = delzc2->begin();
    iTAB itu = zr->begin();
    iTAB itd = zl->getIterator(0,1);

    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            delzc2temp = zr->getValue(itu)-zl->getValue(itd);
            delzc2->setValue(delzc2temp,itc);
            //increment iterateurs
            ++itc;
            ++itu;
            ++itd;
        }
    }
}
END(order2_delzc2_f);
//-------------------------------------------------------------------------------
//CACUL huv1
//-------------------------------------------------------------------------------
BEGINApplyList(order2_huv1_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h = inputs[0];//2
    TAB u = inputs[1];//2
    TAB v = inputs[2];//2
    TAB z = inputs[3];//2
    TAB h1l = outputs[0];//0
    TAB h1r = outputs[1];//0
    TAB u1l = outputs[2];//0
    TAB u1r = outputs[3];//0
    TAB v1l = outputs[4];//0
    TAB v1r = outputs[5];//0
    TAB z1l = outputs[6];//0
    TAB z1r = outputs[7];//0

    parameters * par = parameters::getSingleton();
    rec_muscl * rec = rec_muscl::getSingleton(par->get_lim());

    iTAB it_2 = h->begin();
    iTAB it_0 = h1l->begin();

    unsigned int width = h->getWidth();
    unsigned int height = h->getHeight();

    SCALAR dh1,dh2,du1,du2,dv1,dv2,dz1,dz2;
    SCALAR hl,ul,vl,zl,hr,ur,vr,zr;

    DMatrix<SCALAR>::neighbors hf = new SCALAR[4];
    DMatrix<SCALAR>::neighbors uf = new SCALAR[4];
    DMatrix<SCALAR>::neighbors vf = new SCALAR[4];
    DMatrix<SCALAR>::neighbors zf = new SCALAR[4];

    for(int j=0; j<height; j++) {

        // valeur sur les cellules fictives
        hf = h->getXNeighbors(it_2,hf);
        uf = u->getXNeighbors(it_2,uf);
        vf = v->getXNeighbors(it_2,vf);
        zf = z->getXNeighbors(it_2,zf);
        //attention ordre: 2--0--it--1--3

        // a la cellule fictive
        dh1 = hf[0]-hf[2];
        du1 = uf[0]-uf[2];
        dv1 = vf[0]-vf[2];
        dz1 = zf[0]-zf[2];
        dh2 = h->getValue(it_2)-hf[0];
        du2 = u->getValue(it_2)-uf[0];
        dv2 = v->getValue(it_2)-vf[0];
        dz2 = z->getValue(it_2)-zf[0];
        rec->calcul(hf[0],uf[0],vf[0],zf[0],dh1,dh2,du1,du2,dv1,dv2,dz1,dz2);
        hr = rec->get_hr();
        ur = rec->get_ur();
        vr = rec->get_vr();
        zr = rec->get_zr();

        for(int i=0; i<width; i++) {
            //--------------------------------//
            // a gauche de l'interface
            h1l->setValue(hr,it_0);
            u1l->setValue(ur,it_0);
            v1l->setValue(vr,it_0);
            z1l->setValue(zr,it_0);
            // calculer la pente
            dh1 = dh2;
            du1 = du2;
            dv1 = dv2;
            dz1 = dz2;
            dh2 = h->getRightNeighbor(it_2) - h->getValue(it_2);
            du2 = u->getRightNeighbor(it_2) - u->getValue(it_2);
            dv2 = v->getRightNeighbor(it_2) - v->getValue(it_2);
            dz2 = z->getRightNeighbor(it_2) - z->getValue(it_2);
            rec->calcul(h->getValue(it_2),u->getValue(it_2),v->getValue(it_2),z->getValue(it_2),dh1,dh2,du1,du2,dv1,dv2,dz1,dz2);
            hl = rec->get_hl();
            ul = rec->get_ul();
            vl = rec->get_vl();
            zl = rec->get_zl();
            // a droite de l'interface
            h1r->setValue(hl,it_0);
            u1r->setValue(ul,it_0);
            v1r->setValue(vl,it_0);
            z1r->setValue(zl,it_0);
            // pour l'interface suivante
            hr = rec->get_hr();
            ur = rec->get_ur();
            vr = rec->get_vr();
            zr = rec->get_zr();

            ++it_2;
            ++it_0;
        }
        //at width-1
        --it_2;

        // a gauche de l'interface
        h1l->setValue(hr,it_0);
        u1l->setValue(ur,it_0);
        v1l->setValue(vr,it_0);
        z1l->setValue(zr,it_0);

        dh1 = dh2;
        du1 = du2;
        dv1 = dv2;
        dz1 = dz2;
        // valeur sur les cellules fictives
        hf = h->getXNeighbors(it_2,hf);
        uf = u->getXNeighbors(it_2,uf);
        vf = v->getXNeighbors(it_2,vf);
        zf = z->getXNeighbors(it_2,zf);
        // a la cellule fictive
        dh2 = hf[3]-hf[1];
        du2 = uf[3]-uf[1];
        dv2 = vf[3]-vf[1];
        dz2 = zf[3]-zf[1];
        rec->calcul(hf[1],uf[1],vf[1],zf[1],dh1,dh2,du1,du2,dv1,dv2,dz1,dz2);
        hl = rec->get_hl();
        ul = rec->get_ul();
        vl = rec->get_vl();
        zl = rec->get_zl();
        // a droite de l'interface
        h1r->setValue(hl,it_0);
        u1r->setValue(ul,it_0);
        v1r->setValue(vl,it_0);
        z1r->setValue(zl,it_0);

        ++it_2;
        ++it_0;
    }
    delete [] hf;
    delete [] uf;
    delete [] vf;
    delete [] zf;

}
END(order2_huv1_f);
//-------------------------------------------------------------------------------

//CACUL huv2
//-------------------------------------------------------------------------------
BEGINApplyList(order2_huv2_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h = inputs[0];//2
    TAB u = inputs[1];//2
    TAB v = inputs[2];//2
    TAB z = inputs[3];//2
    TAB h2l = outputs[0];//0
    TAB h2r = outputs[1];//0
    TAB u2l = outputs[2];//0
    TAB u2r = outputs[3];//0
    TAB v2l = outputs[4];//0
    TAB v2r = outputs[5];//0
    TAB z2l = outputs[6];//0
    TAB z2r = outputs[7];//0

    parameters * par = parameters::getSingleton();
    rec_muscl * rec = rec_muscl::getSingleton(par->get_lim());

    unsigned int width = h->getWidth();
    SCALAR dh1,dh2,du1,du2,dv1,dv2,dz1,dz2;
    SCALAR hl,ul,vl,zl,hr,ur,vr,zr;

    DMatrix<SCALAR>::neighbors hf = new SCALAR[4];
    DMatrix<SCALAR>::neighbors uf = new SCALAR[4];
    DMatrix<SCALAR>::neighbors vf = new SCALAR[4];
    DMatrix<SCALAR>::neighbors zf = new SCALAR[4];

    iTAB it_2 = h->begin();
    iTAB it_0r = h2l->begin();
    //premiere ligne des interface en haut
    for(int i=0; i<width; i++) {
        // valeur sur les cellules fictives
        hf = h->getYNeighbors(it_2,hf);
        uf = u->getYNeighbors(it_2,uf);
        vf = v->getYNeighbors(it_2,vf);
        zf = z->getYNeighbors(it_2,zf);
        //                 2
        //                 0
        //attention ordre: it
        //                 1
        //                 3
        // a la cellule fictive
        dh1 = hf[0]-h->getValue(it_2);
        du1 = uf[0]-u->getValue(it_2);
        dv1 = vf[0]-v->getValue(it_2);
        dz1 = zf[0]-z->getValue(it_2);
        dh2 = hf[2]-hf[0];
        du2 = uf[2]-uf[0];
        dv2 = vf[2]-vf[0];
        dz2 = zf[2]-zf[0];

        rec->calcul(hf[0],uf[0],vf[0],zf[0],dh1,dh2,du1,du2,dv1,dv2,dz1,dz2);
        hl = rec->get_hl();
        ul = rec->get_ul();
        vl = rec->get_vl();
        zl = rec->get_zl();
        h2r->setValue(hl,it_0r);
        u2r->setValue(ul,it_0r);
        v2r->setValue(vl,it_0r);
        z2r->setValue(zl,it_0r);
        ++it_2;
        ++it_0r;
    }

    it_2 = h->begin();
    iTAB it_hEnd = h->end();
    iTAB it_0l = h2l->begin();
    for(; it_2<=it_hEnd; ++it_2,++it_0l,++it_0r) {
        dh1 = h->getValue(it_2)-h->getDownNeighbor(it_2);
        du1 = u->getValue(it_2)-u->getDownNeighbor(it_2);
        dv1 = v->getValue(it_2)-v->getDownNeighbor(it_2);
        dz1 = z->getValue(it_2)-z->getDownNeighbor(it_2);
        dh2 = h->getUpNeighbor(it_2)-h->getValue(it_2);
        du2 = u->getUpNeighbor(it_2)-u->getValue(it_2);
        dv2 = v->getUpNeighbor(it_2)-v->getValue(it_2);
        dz2 = z->getUpNeighbor(it_2)-z->getValue(it_2);
        rec->calcul(h->getValue(it_2),u->getValue(it_2),v->getValue(it_2),z->getValue(it_2),dh1,dh2,du1,du2,dv1,dv2,dz1,dz2);
        hl = rec->get_hl();
        ul = rec->get_ul();
        vl = rec->get_vl();
        zl = rec->get_zl();
        // a droite de l'interface
        h2r->setValue(hl,it_0r);
        u2r->setValue(ul,it_0r);
        v2r->setValue(vl,it_0r);
        z2r->setValue(zl,it_0r);
        // pour l'interface suivante
        hr = rec->get_hr();
        ur = rec->get_ur();
        vr = rec->get_vr();
        zr = rec->get_zr();
        // a gauche de l'interface
        h2l->setValue(hr,it_0l);
        u2l->setValue(ur,it_0l);
        v2l->setValue(vr,it_0l);
        z2l->setValue(zr,it_0l);
    }

    iTAB it_0End = h2l->end();
    for(; it_0End>=it_0l; --it_0End,--it_hEnd) {
        // valeur sur les cellules fictives
        hf = h->getYNeighbors(it_hEnd,hf);
        uf = u->getYNeighbors(it_hEnd,uf);
        vf = v->getYNeighbors(it_hEnd,vf);
        zf = z->getYNeighbors(it_hEnd,zf);
        //                 2
        //                 0
        //attention ordre: it
        //                 1
        //                 3
        // a la cellule fictive
        dh1 = hf[1]-hf[3];
        du1 = uf[1]-uf[3];
        dv1 = vf[1]-vf[3];
        dz1 = zf[1]-zf[3];
        dh2 = h->getValue(it_hEnd)-hf[1];
        du2 = u->getValue(it_hEnd)-uf[1];
        dv2 = v->getValue(it_hEnd)-vf[1];
        dz2 = z->getValue(it_hEnd)-zf[1];

        rec->calcul(hf[1],uf[1],vf[1],zf[1],dh1,dh2,du1,du2,dv1,dv2,dz1,dz2);
        hr = rec->get_hr();
        ur = rec->get_ur();
        vr = rec->get_vr();
        zr = rec->get_zr();
        h2l->setValue(hr,it_0End);
        u2l->setValue(ur,it_0End);
        v2l->setValue(vr,it_0End);
        z2l->setValue(zr,it_0End);
    }
    delete [] hf;
    delete [] uf;
    delete [] vf;
    delete [] zf;

}
END(order2_huv2_f);
//-------------------------------------------------------------------------------

//Heun_HQ
//-------------------------------------------------------------------------------
BEGINApplyList(Heun_hq_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h = outputs[0];
    TAB q1 = outputs[1];
    TAB q2 = outputs[2];
    TAB hs = outputs[3];
    TAB qs1 = outputs[4];
    TAB qs2 = outputs[5];

    iTAB it_2 = h->begin();
    iTAB it_0 = q1->begin();
    iTAB it_hEnd = h->end();
    for(; it_2<=it_hEnd; it_2++,++it_0) {
        h->setValue(0.5*(h->getValue(it_2)+hs->getValue(it_2)),it_2);
        q1->setValue(0.5*(q1->getValue(it_0)+qs1->getValue(it_0)),it_0);
        q2->setValue(0.5*(q2->getValue(it_0)+qs2->getValue(it_0)),it_0);
    }
}
END(Heun_hq_f);

#endif
