#ifndef SCHEME_PARALLEL_H
#define SCHEME_PARALLEL_H

#include "scheme.hpp"

//BLOC1x
//-------------------------------------------------------------------------------
BEGINApplyList(bloc1x_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h1l = inputs[0];
    TAB h1r = inputs[1];
    TAB u1l = inputs[2];
    TAB u1r = inputs[3];
    TAB v1l = inputs[4];
    TAB v1r = inputs[5];
    TAB delz1 = inputs[6];
    TAB h1g = outputs[0];
    TAB h1d = outputs[1];
    TAB f1 = outputs[2];
    TAB f2 = outputs[3];
    TAB f3 = outputs[4];

    iTAB it = h1l->begin();
    iTAB itEnd = h1l->end();

    parameters * par = parameters::getSingleton();
    hydrostatic * rec_hydro = hydrostatic::getSingleton();
    choice_flux * flux_num = choice_flux::getSingleton(par->get_flux());

    SCALAR cfl_fix = par->get_cflfix();
    SCALAR cfl = 0;
    SCALAR tx = par->get_dtfix()/par->get_dx();

    for(; it<=itEnd; ++it) {
        rec_hydro->calcul(h1l->getValue(it),h1r->getValue(it),delz1->getValue(it));
        h1g->setValue(rec_hydro->hg(),it);
        h1d->setValue(rec_hydro->hd(),it);
        flux_num->calcul(h1g->getValue(it),u1l->getValue(it),v1l->getValue(it),h1d->getValue(it),u1r->getValue(it),v1r->getValue(it));
        f1->setValue(flux_num->get_f1(),it);
        f2->setValue(flux_num->get_f2(),it);
        f3->setValue(flux_num->get_f3(),it);

        cfl=max(cfl,flux_num->get_cfl());
    }

    if(cfl*tx>cfl_fix)
        std::cout<<"cfl conditioin is not satisfied in x"<<std::endl;
}
END(bloc1x_f);
//-------------------------------------------------------------------------------

//BLOC1y
//-------------------------------------------------------------------------------
BEGINApplyList(bloc1y_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h2l = inputs[0];
    TAB h2r = inputs[1];
    TAB u2l = inputs[2];
    TAB u2r = inputs[3];
    TAB v2l = inputs[4];
    TAB v2r = inputs[5];
    TAB delz2 = inputs[6];
    TAB h2g = outputs[0];
    TAB h2d = outputs[1];
    TAB g1 = outputs[2];
    TAB g2 = outputs[3];
    TAB g3 = outputs[4];

    iTAB it = h2l->begin();
    iTAB itEnd = h2l->end();

    parameters * par = parameters::getSingleton();
    hydrostatic * rec_hydro = hydrostatic::getSingleton();
    choice_flux * flux_num = choice_flux::getSingleton(par->get_flux());

    SCALAR cfl_fix = par->get_cflfix();
    SCALAR cfl = 0;
    SCALAR ty = par->get_dtfix()/par->get_dy();

    for(; it<=itEnd; ++it) {
        rec_hydro->calcul(h2l->getValue(it),h2r->getValue(it),delz2->getValue(it));
        h2g->setValue(rec_hydro->hg(),it);
        h2d->setValue(rec_hydro->hd(),it);
        flux_num->calcul(h2g->getValue(it),v2l->getValue(it),u2l->getValue(it),h2d->getValue(it),v2r->getValue(it),u2r->getValue(it));
        g1->setValue(flux_num->get_f1(),it);
        g3->setValue(flux_num->get_f2(),it);
        g2->setValue(flux_num->get_f3(),it);

        cfl=max(cfl,flux_num->get_cfl());
    }

    if(cfl*ty>cfl_fix)
        std::cout<<"cfl conditioin is not satisfied in y"<<std::endl;
}
END(bloc1y_f);
//-------------------------------------------------------------------------------

//BLOC2
//-------------------------------------------------------------------------------
BEGINApplyList(bloc2_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB he = inputs[0];//2
    TAB ve1 = inputs[1];//2
    TAB ve2 = inputs[2];//2
    TAB qe1 = inputs[3];//0
    TAB qe2 = inputs[4];//0
    TAB h1l = inputs[5];
    TAB h1r = inputs[6];
    TAB h1g = inputs[7];
    TAB h1d = inputs[8];
    TAB h2l = inputs[9];
    TAB h2r = inputs[10];
    TAB h2g = inputs[11];
    TAB h2d = inputs[12];
    TAB delzc1 = inputs[13];//0
    TAB delzc2 = inputs[14];//0
    TAB f1 = inputs[15];
    TAB f2 = inputs[16];
    TAB f3 = inputs[17];
    TAB g1 = inputs[18];
    TAB g2 = inputs[19];
    TAB g3 = inputs[20];

    TAB hes = outputs[0];//2
    TAB qes1 = outputs[1];//0
    TAB qes2 = outputs[2];//0

    parameters * par = parameters::getSingleton();
//    choice_friction * fric = choice_friction::getSingleton(par);
    SCALAR ty = par->get_dtfix()/par->get_dy();
    SCALAR tx = par->get_dtfix()/par->get_dx();
    SCALAR dt = par->get_dtfix();

    SCALAR hnew = 0;
    SCALAR q1new = 0;
    SCALAR q2new = 0;

    unsigned int width = he->getWidth();
    unsigned int height = he->getHeight();

    //initialisation iterateurs
    iTAB itc = delzc1->begin();
    iTAB it = he->begin();
    iTAB itl = f1->begin();
    iTAB itr = f1->begin();
    ++itr;
    iTAB itu = g1->begin();
    iTAB itd = g1->getIterator(0,1);

    for(int i=0; i<height; i++) {
        for(int j=0; j<width; j++) {
            hnew = he->getValue(it)-tx*(f1->getValue(itr)-f1->getValue(itl))-ty*(g1->getValue(itu)-g1->getValue(itd));
            q1new = qe1->getValue(itc)-tx*(f2->getValue(itr)-f2->getValue(itl)+grav_dem*(h1d->getValue(itl)*h1d->getValue(itl)-h1r->getValue(itl)*h1r->getValue(itl)+h1l->getValue(itr)*h1l->getValue(itr)-h1g->getValue(itr)*h1g->getValue(itr)+(h1r->getValue(itl)+h1l->getValue(itr))*delzc1->getValue(itc)))-ty*(g2->getValue(itu)-g2->getValue(itd));
            q2new = qe2->getValue(itc)-tx*(f3->getValue(itr)-f3->getValue(itl))-ty*(g3->getValue(itu)-g3->getValue(itd)+grav_dem*(h2d->getValue(itd)*h2d->getValue(itd)-h2r->getValue(itd)*h2r->getValue(itd)+h2l->getValue(itu)*h2l->getValue(itu)-h2g->getValue(itu)*h2g->getValue(itu)+(h2r->getValue(itd)+h2l->getValue(itu))*delzc2->getValue(itc)));
            /*      if (hnew > he_ca) { //Calcul friction in semi-implicit.
                      fric->calcul(ve1->getValue(it),ve2->getValue(it),hnew,q1new,q2new,dt,itc);
                      q1new = fric->get_q1mod();
                      q2new = fric->get_q2mod();
                  }
                  */
            hes->setValue(hnew,it);
            qes1->setValue(q1new,itc);
            qes2->setValue(q2new,itc);

            //increment iterateurs
            ++it;
            ++itc;
            ++itl;
            ++itr;
            ++itu;
            ++itd;
        }
        //re-init left and right iterators
        ++itl;
        ++itr;
    }
}
END(bloc2_f);
//-------------------------------------------------------------------------------

//BUNDARY
//-------------------------------------------------------------------------------
BEGINApplyList(boundary_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB he = outputs[0];
    TAB ve1 = outputs[1];
    TAB ve2 = outputs[2];

    unsigned int width = he->getWidth();
    unsigned int height = he->getHeight();

    iTAB it;

    parameters * par = parameters::getSingleton();
    choice_condition_left * Lbound = choice_condition_left::getSingleton(par->get_Lbound());
    choice_condition_right * Rbound = choice_condition_right::getSingleton(par->get_Rbound());
    choice_condition_bottom * Bbound = choice_condition_bottom::getSingleton(par->get_Bbound());
    choice_condition_top * Tbound = choice_condition_top::getSingleton(par->get_Tbound());

    SCALAR left_imp_discharge = par->get_left_imp_discharge();
    SCALAR left_imp_h = par->get_left_imp_h();
    SCALAR right_imp_discharge = par->get_right_imp_discharge();
    SCALAR right_imp_h = par->get_right_imp_h();
    SCALAR bottom_imp_discharge = par->get_bottom_imp_discharge();
    SCALAR bottom_imp_h = par->get_bottom_imp_h();
    SCALAR top_imp_discharge = par->get_top_imp_discharge();
    SCALAR top_imp_h = par->get_top_imp_h();

    //left physical values
    //condition limite
    if(he->isPhysicalBorder(he->getIterator(0,1))) {
        for(int i=0; i<height; i++) {
            it = he->getIterator(0,i);
            Lbound->calcul(he->getValue(it),ve1->getValue(it),ve2->getValue(it),left_imp_h,left_imp_discharge);
            he->setPhysicalLeftValue(Lbound->get_hbound(),it);
            ve1->setPhysicalLeftValue(Lbound->get_unormbound(),it);
            ve2->setPhysicalLeftValue(Lbound->get_utanbound(),it);
        }
    }

    //right physical values
    //condition limite
    if(he->isPhysicalBorder(he->getIterator(width-1,1))) {
        for(int i=0; i<height; i++) {
            it = he->getIterator(width-1,i);
            Rbound->calcul(he->getValue(it),ve1->getValue(it),ve2->getValue(it),right_imp_h,right_imp_discharge);
            he->setPhysicalRightValue(Rbound->get_hbound(),it);
            ve1->setPhysicalRightValue(Rbound->get_unormbound(),it);
            ve2->setPhysicalRightValue(Rbound->get_utanbound(),it);
        }
    }

    //up physical values
    //condition limite
    if(he->isPhysicalBorder(he->getIterator(1,0))) {
        for(int i=0; i<width; i++) {
            it = he->getIterator(i,0);
            Tbound->calcul(he->getValue(it),ve2->getValue(it),ve1->getValue(it),top_imp_h,top_imp_discharge);
            he->setPhysicalUpValue(Tbound->get_hbound(),it);
            ve2->setPhysicalUpValue(Tbound->get_unormbound(),it);
            ve1->setPhysicalUpValue(Tbound->get_utanbound(),it);
        }
    }

    //down physical values
    //condition limite
    if(he->isPhysicalBorder(he->getIterator(1,height-1))) {
        for(int i=0; i<width; i++) {
            it = he->getIterator(i,height-1);
            Bbound->calcul(he->getValue(it),ve2->getValue(it),ve1->getValue(it),bottom_imp_h,bottom_imp_discharge);
            he->setPhysicalDownValue(Bbound->get_hbound(),it);
            ve2->setPhysicalDownValue(Bbound->get_unormbound(),it);
            ve1->setPhysicalDownValue(Bbound->get_utanbound(),it);
        }
    }
}
END(boundary_f);
//-------------------------------------------------------------------------------

//VERIFICATION 0
//-------------------------------------------------------------------------------
BEGINApplyList(ve_ca_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h = outputs[0];//2
    TAB u = outputs[1];//2
    TAB v = outputs[2];//2
    TAB q1 = outputs[3];//0
    TAB q2 = outputs[4];//0

    iTAB it_2 = h->begin();
    iTAB it_0 = q1->begin();
    iTAB it_hEnd = h->end();

    for(; it_2<=it_hEnd; it_2++,++it_0) {
        if (h->getValue(it_2)<he_ca) {
            h->setValue(0.,it_2);
            u->setValue(0.,it_2);
            v->setValue(0.,it_2);
            q1->setValue(0.,it_0);
            q2->setValue(0.,it_0);
        } else {
            u->setValue(q1->getValue(it_0)/h->getValue(it_2),it_2);
            if (fabs(u->getValue(it_2))<ve_ca) {
                u->setValue(0.,it_2);
                q1->setValue(0.,it_0);
            }
            v->setValue(q2->getValue(it_0)/h->getValue(it_2),it_2);
            if (fabs(v->getValue(it_2))<ve_ca) {
                v->setValue(0.,it_2);
                q2->setValue(0.,it_0);
            }
        }
    }
}
END(ve_ca_f);
//-------------------------------------------------------------------------------

//UPDATE HQ
//-------------------------------------------------------------------------------
BEGINApplyList(update_hq_f,inputs,SCALAR,outputs,SCALAR)
//-------------------------------------------------------------------------------
{
    TAB h = outputs[0];
    TAB q1 = outputs[1];
    TAB q2 = outputs[2];
    TAB hs = outputs[3];
    TAB qs1 = outputs[4];
    TAB qs2 = outputs[5];

    iTAB it_2 = h->begin();
    iTAB it_0 = q1->begin();
    iTAB it_hEnd = h->end();

    for(; it_2<=it_hEnd; it_2++,++it_0) {
        h->setValue(hs->getValue(it_2),it_2);
        q1->setValue(qs1->getValue(it_0),it_0);
        q2->setValue(qs2->getValue(it_0),it_0);
    }
}
END(update_hq_f);
//-------------------------------------------------------------------------------

//BOUNDARY Z
//-------------------------------------------------------------------------------
BEGINApplyOneMat(boundaryz_f,zi,SCALAR,z,SCALAR)
//-------------------------------------------------------------------------------
{
    unsigned int width = z->getWidth();
    unsigned int height = z->getHeight();

    iTAB it;

    //left physical values
    //condition limite
    if(z->isPhysicalBorder(z->getIterator(0,1))) {
        for(int i=0; i<height; i++) {
            it = z->getIterator(0,i);
            z->setPhysicalLeftValue(z->getValue(it),it);
        }
    }

    //right physical values
    //condition limite
    if(z->isPhysicalBorder(z->getIterator(width-1,1))) {
        for(int i=0; i<height; i++) {
            it = z->getIterator(width-1,i);
            z->setPhysicalRightValue(z->getValue(it),it);
        }
    }

    //up physical values
    //condition limite
    if(z->isPhysicalBorder(z->getIterator(1,0))) {
        for(int i=0; i<width; i++) {
            it = z->getIterator(i,0);
            z->setPhysicalUpValue(z->getValue(it),it);
        }
    }

    //down physical values
    //condition limite
    if(z->isPhysicalBorder(z->getIterator(1,height-1))) {
        for(int i=0; i<width; i++) {
            it = z->getIterator(i,height-1);
            z->setPhysicalDownValue(z->getValue(it),it);
        }
    }
}
END(boundaryz_f);
//-------------------------------------------------------------------------------

#endif
