#ifndef BASE_H
#define BASE_H
#include <stdexcept>

// structure mere pour le 1eme apply
template <typename T, typename T2>
struct _ApplyOneMat
{
  virtual void operator()(DMatrix <T> *, DMatrix<T2> *) const =0;
};

// structure mere pour le 2eme apply
template <typename T, typename T2, typename T3 >
struct _ApplyTwoMat
{
  virtual void operator()(DMatrix <T> *, DMatrix<T2> *, DMatrix<T3> *) const =0;
};

// structure mere pour le 2eme apply
template <typename T, typename T2>
struct _ApplyList
{
  virtual void operator()(std::vector<DMatrix <T> * >&,std::vector<DMatrix<T2> * >&) const =0;
};

// structure mere pour le 3eme apply
template <typename T>
struct _ApplyJustOneMat
{
  virtual T operator()(DMatrix<T> * ) const =0;
};

//structure mere pour applyStar
template<typename T, typename T2>
struct _ApplyStar
{
  virtual void operator()(DMatrix<int>*, DMatrix<int>*, DMatrix<int>*) const =0;
};

// structure mere pour la surcharge du map
template <typename T, typename T2>
struct _map
{
  virtual T2 operator()(T toModifiy) const =0;
};

// structure mere pour la surcharge du zipWith
template <typename T, typename T2, typename T3>
struct _zipWith
{
  virtual T operator()(T2 toModifiy, T3 toModifiy2) const =0;
};

// structure mere pour la surcharge du reduce
template <typename T>
struct _reduce
{
  virtual T operator()(T toModifiy, T toModifiy2) const =0;
};

//-------------------------------------------------------------------------------
// Mappeur part, 1 matrice input
template<class T, class T2>
struct mapStruct : public _ApplyOneMat<T, T2>
{
  const _map<T, T2> *func;

  void operator()(DMatrix<T> * input, DMatrix<T2> * output) const
  {
    //-----call to func
    typename DMatrix<T>::iterator itBeg = input->begin();
    typename DMatrix<T>::iterator itEnd = input->end();
    typename DMatrix<T>::iterator itOut = output->begin();

    for(; itBeg <= itEnd; ++itBeg , ++itOut)
    {
      output->setValue((*func)(*itBeg), itOut);
    }
 }
};

//-------------------------------------------------------------------------------

// zipWith, 2 input matrix
template<class T, class T2, class T3>
struct zipWithStruct : public _ApplyTwoMat<T, T2, T3>
{
  const _zipWith<T,T2,T3>* func;

  void operator()(DMatrix<T> * input, DMatrix<T2> * input2, DMatrix<T3> * output) const
  {
    DMatrix<float>::iterator itBeg = input->begin();
    DMatrix<float>::iterator itBeg2 = input2->begin();
    DMatrix<float>::iterator itOut = output->begin();

    for(; itBeg <= input->end() && itBeg2 <= input2->end(); ++itBeg, ++itBeg2, ++itOut)
      {
	T inp = input->getValue(itBeg.rank);
	T inp2 = input2->getValue(itBeg2.rank);
	//output->setValue((*func)(*itBeg, *itBeg2), itOut);
	output->setValue((*func)(inp, inp2), itOut.rank);
      }
  }
  };

//-------------------------------------------------------------------------------

//-------------------------------------------------------------------------------
// Mappeur part, 1 matrice input
template<class T>
struct reduceStruct : public _ApplyJustOneMat<T>
{
  const _reduce<T>* func;
  
  T operator()(DMatrix<T> * input) const
  {
    //-----call to func
    typename DMatrix<T>::iterator itBeg = input->begin();
    typename DMatrix<T>::iterator itEnd = input->end();
    
    T res=*itBeg;
    
    for(; itBeg <= itEnd; ++itBeg)
      {
	res=(*func)(res, *itBeg);
      }
    
    return res;
  }
  };

//-------------------------------------------------------------------------------
#endif
