//!  template Iterator for Dmatrix Class
/*!
  T = type of data in the matrix
*/


//for the frendship between Dmatrix end DIterator
template <class T> 
class DMatrix;


//------------Templated iterator class for DMatrix
template<class T>
class DIterator
{
 public:
  //! pointeur to the value 
  //T* p;
  //! rank of the iterator
  unsigned int rank;
  //! border managed by the dmatrix
  int border;
  //! width of the matrix (with border)
  unsigned int width;

  //void setRank(unsigned int newRank){rank=newRank;}

  //------------ Constructeurs
  
  //! constructor of the iterator
 DIterator() : /*p(NULL),*/ rank(0), border(0), width(0){}

  //! constructor of the iterator
  ///! \param x is the new value of p
  //DIterator(T* x) :p(x){} //is called if  it = T*
  
  //! constructor by recopie of the iterator
  ///! \param myIt is the new value of the current (this) iterator
 DIterator(const DIterator& myIt) : /*p(myIt.p),*/ rank(myIt.rank){}//is called if it = it2
  //---------------------------


  //------------ incrementation section
  
  //! surcharge of operator++, pre-incrementation
  DIterator& operator++() 
  {
    //if(border>0)
    //{
    //((rank+1)%width<(width-border)) ? ++rank : rank=rank+border*2+1;
    if((rank+1)%width<(width-border))
      {
	++rank;
	//++p;
      }
    else
      {
	rank=rank+border*2+1;
	//p=p+border*2+1;
      }
	/*}
    else
      {
	++rank;
	++p;
	}*/
    return *this;
  }//pre-incrementation

  //! surcharge of operator++, post-incrementation
  DIterator& operator++(int)
  {
    /*if(border>0)
      {*/
    if((rank+1)%width<(width-border))
      {
	++rank;
	//++p;
      }
    else
      {
	rank=rank+border*2+1;
	//p=p+border*2+1;
      }
    /*}
	  else
      {
	rank++;
	p++;
	}*/
    return *this;
  } //post-incrementation
  //DIterator operator++(int) {DIterator aux(*this); rank++ ;operator++(); return aux;} //post-incrementation
  //---------------------------

   //------------Decrementation
  //! surcharge of operator++, pre-Decrementation
  DIterator& operator--() 
  {
    if((rank-1)%width>(border-1))
	--rank;
    else
	rank=rank-border*2-1;
    return *this;
  }//pre-Decrementation
  //---------------------------


  //------------Comparaison operators

  //! surcharge of operator==, comparison operator
  ///! \param toTest is the iterator to compare with the current (this) iterator
  ///! \return boolean, equality(true) or unequality(false)
  bool operator==(const DIterator& toTest) {return rank==toTest.getRank();}
  //! surcharge of operator!=, comparison operator
  ///! \param toTest is the iterator to compare with the current (this) iterator
  ///! \return boolean, unequality(true) or equality(false)
  bool operator!=(const DIterator& toTest) {return rank!=toTest.getRank();}
  //! surcharge of operator<=, comparison operator
  ///! \param toTest is the iterator to compare with the current (this) iterator
  ///! \return boolean, inferiority(true) or superiority(false)
  bool operator <=(const DIterator& toComp) {return getRank()<=toComp.getRank();}
   //! surcharge of operator>, comparison operator
  ///! \param toTest is the iterator to compare with the current (this) iterator
  ///! \return boolean, inferiority(true) or superiority(false)
  bool operator >(const DIterator& toComp) {return getRank()>toComp.getRank();}
   //! surcharge of operator>=, comparison operator
  ///! \param toTest is the iterator to compare with the current (this) iterator
  ///! \return boolean, inferiority(true) or superiority(false)
  bool operator >=(const DIterator& toComp) {return getRank()>=toComp.getRank();}
  //---------------------------


  //! surcharge of operator*, access operator
  ///! \return T, the value of the element pointed by the iterator
  //T& operator*() {return *p;}

  //------------Getteur section

  //! getteur of the value's iterator 
  //T *getValue() const{return p;}
  //! getteur of the rank's iterator 
  unsigned int getRank() const{return rank;}
  //---------------------------

  //friendship between Dmatrix and DIterator
  friend class DMatrix<T>;
};
