#ifndef MACROS_H
#define MACROS_H

#include "mpi.h"
#include "omp.h"
#include "base.h"

//------------OMP PRAGMA
#define OMP_PAR _Pragma("omp parallel")
#define OMP_MASTER _Pragma("omp master")
#define OMP_BARRIER _Pragma("omp barrier")
//------------
//------------MPI FUNCS
#define MPI_RANK_NB MPI_Comm_size(MPI_COMM_WORLD,&(Mpiomp::mpi_nb));	\
MPI_Comm_rank(MPI_COMM_WORLD,&(Mpiomp::mpi_rank));
#define MPI_END MPI_Finalize();
//------------
//------------SKELGIS INIT
#ifdef _OPENMP
#define INITSKELGIS MPI_Init_thread(&argc,&argv,MPI_THREAD_MULTIPLE,&(Mpiomp::level_provided)); \
MPI_RANK_NB \
int num_threads=0; \
OMP_PAR \
{ \
OMP_MASTER \
{ \
  num_threads = omp_get_num_threads()/2; \
} \
} \
omp_set_num_threads(num_threads); \
OMP_PAR \
{ \
OMP_MASTER \
{ \
Mpiomp::omp_nb = omp_get_num_threads(); \
} \
OMP_BARRIER
#else
#define INITSKELGIS MPI_Init(&argc,&argv); \
MPI_RANK_NB
#endif
//-----------
//-----------SKELGIS END
#ifdef _OPENMP
#define ENDSKELGIS OMP_BARRIER \
} \
MPI_END
#else
#define ENDSKELGIS MPI_END
#endif
//---------- 
//------------SKELETON MACRO
/**
* 1st apply
*/
#define BEGINApplyOneMat(nameOccur, matriceEntree, type1, matriceSortie, type2) struct _ApplyOneMat_##nameOccur : public _ApplyOneMat<type1, type2> \
{ \
  void operator()(DMatrix<type1> * matriceEntree, DMatrix<type2> * matriceSortie) const

/**
* 2nd apply
*/
#define BEGINApplyTwoMat(nameOccur, matriceEntree, type1, matriceEntree2, type2, matriceSortie, type3) struct _ApplyTwoMat_##nameOccur : public _ApplyTwoMat<type1,type2,type3> \
{ \
  void operator()(DMatrix<type1> * matriceEntree, DMatrix<type2> * matriceEntree2, DMatrix<type3> * matriceSortie) const

/**
* apply on lists
*/
#define BEGINApplyList(nameOccur, inputs, type1, outputs, type2) struct _ApplyList_##nameOccur : public _ApplyList<type1,type2> \
{ \
    void operator()(std::vector<DMatrix<type1> * >& inputs, std::vector<DMatrix<type2> * >& outputs) const

/**
* 3eme apply
*/
#define BEGINApplyJustOneMat(nameOccur, matrixName, typeMatrix) struct _ApplyJustOneMat_##nameOccur : public _ApplyJustOneMat<typeMatrix> \
{ \
  typeMatrix operator()(DMatrix<typeMatrix> * matrixName) const

/**
* applyStar
*/
#define BEGINApplyStar(nameOccur, init, typeMatrix, m2, returnType) struct _ApplyStar_##nameOccur : public _ApplyStar<typeMatrix, returnType> \
{ \
  void operator()(DMatrix<typeMatrix>* m1, DMatrix<typeMatrix>* init, DMatrix<typeMatrix>* m2) const


/**
* Map's macro
*/
#define BEGINMAP(nameMap, returnType, toModifiy, type) struct _map_##nameMap : public _map<type, returnType> \
{ \
  returnType operator()(type toModifiy) const

/**
* zipWith's macro
*/
#define BEGINZIPWITH(nameZip, returnType,toModifiy, type1, toModifiy2, type2) struct _map_##nameZip : public _zipWith<type1, type2, returnType> \
{ \
  returnType operator()(type1 toModifiy, type2 toModifiy2) const

/**
* reduce's macro
*/
#define BEGINREDUCE(nameReduc, toModifiy, toModifiy2, typeUnique) struct _reduce_##nameReduc : public _reduce<typeUnique> \
{ \
  typeUnique operator()(typeUnique toModifiy, typeUnique toModifiy2) const



//user have to name the occurence of what he've just create, and call it to the end of his code, in the main
#define END(nameFunc)  }nameFunc

//------------END SKELETON MACROS

#endif
