#ifndef MPIOMP_H
#define MPIOMP_H

#include <vector>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <string>
#include <iostream>
#include <fstream>
#include <sstream>

#include "mpi.h"
#include "omp.h"

#include "listBase.h"

//using namespace std;

//!  template mpi and omp Class 
/*!
  This template class defines the MPI and OMP initializations, the MPI communications, the OMP synchronizations etc.
*/
//-------------------------------------------------------------------------------
  class Mpiomp
//-------------------------------------------------------------------------------
  {
  public:
  //--------------------------------------
  //VARIABLES
  //--------------------------------------
    static int level_provided;
    static int mpi_rank;
    static int mpi_nb;
    static int omp_nb;

#ifdef _OPENMP
  //a vector containing all the lists of distributed matrix constructed by the threads
  //----------------
    static std::vector<MatrixBase ** > * matrix_lists;
  //----------------
  //a table used for apply3 calculations in hybrid mode
  //----------------
  static ListBase * apply3_results;
  //----------------
#endif
  //--------------------------------------	

  //! Constructor
  /*!
   */
  //-------------------------------------------------------------------------------
    Mpiomp(){}
  //-------------------------------------------------------------------------------

  //! Destructor
  /*!
   */
  //-------------------------------------------------------------------------------
    ~Mpiomp(){}
  //-------------------------------------------------------------------------------

#ifdef _OPENMP
  //! Initialize the apply3 shared values
  /*!
    \param table is the table to point on
  */
  //-------------------------------------------------------------------------------
  static void InitApply3(ListBase * table);
  //-------------------------------------------------------------------------------

  //! Add a matrix list to matrix_lists vector (done thread by thread)
  /*!
    used by the constructor of DMatrix
    \param m is the DMatrix to add to the new list (new list created by omp master)
    \param omp_r is the rank where to put m in the new list
    \return the rank of the new list in the vector
  */
  //-------------------------------------------------------------------------------
  static int AddListMatrix(MatrixBase * m, int omp_r);
  //-------------------------------------------------------------------------------

  //! Get the matrix list
  /*!
    \param list_rank is the rank of the list to get in the vector
    \return the lis wanted
  */
  //-------------------------------------------------------------------------------
    static MatrixBase ** GetList(int list_rank);
  //-------------------------------------------------------------------------------

  //! Erase the list of list
  /*!
   */
  //-------------------------------------------------------------------------------
  //  static void Erase();
  //-------------------------------------------------------------------------------
#endif
  //! Print the string str in output files
  /*!
    Only used for verifications because of synchronizations time
    \param str is the string to print
  */
  //-------------------------------------------------------------------------------
    static void print(std::string str);
  //-------------------------------------------------------------------------------

    //! Print the string str on screen
  /*!
    Only used for verifications because of synchronizations time
    \param str is the string to print
  */
  //-------------------------------------------------------------------------------
    static void printScreen(std::string str);
  //-------------------------------------------------------------------------------
  };

//-------------------------------------------------------------------------------
//Instances
//-------------------------------------------------------------------------------
 /* int Mpiomp::level_provided=0;
  int Mpiomp::mpi_rank=0;
  int Mpiomp::mpi_nb=0;
  int Mpiomp::omp_nb=0;

#ifdef _OPENMP
  std::vector<MatrixBase ** > * Mpiomp::matrix_lists = new std::vector<MatrixBase **>();
//for apply3 skeleton in hybrid mode
ListBase * Mpiomp::apply3_results=NULL;

//-------------------------------------------------------------------------------
void Mpiomp::InitApply3(ListBase * table)
//-------------------------------------------------------------------------------
{
  apply3_results=table;
}

//-------------------------------------------------------------------------------
int Mpiomp::AddListMatrix(MatrixBase * m, int omp_r)
//-------------------------------------------------------------------------------
  {
#pragma omp barrier
#pragma omp master
    {
    //mettre plutôt des flush seul
#pragma omp flush (matrix_lists)
      MatrixBase ** matrix_list = (MatrixBase **)malloc(omp_nb*sizeof(m));
      (Mpiomp::matrix_lists)->push_back(matrix_list);
#pragma omp flush (matrix_lists)
    }
#pragma omp barrier
  //flush is done by barrier
    MatrixBase ** mat = (Mpiomp::matrix_lists)->back();
    mat[omp_r] = m;
  //flush is done by barrier
#pragma omp barrier

    return (Mpiomp::matrix_lists)->size()-1;
  }
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
  MatrixBase ** Mpiomp::GetList(int list_rank)
//-------------------------------------------------------------------------------
  {
  //#pragma omp flush
    return matrix_lists->at(list_rank);
  }*/
//-------------------------------------------------------------------------------
//-------------------------------------------------------------------------------
/*void Mpiomp::Erase()
//-------------------------------------------------------------------------------
{
#pragma omp barrier
#pragma omp master
{
if(matrix_lists->size()==0)
matrix_lists->erase(matrix_lists->begin(),matrix_lists->end());

delete matrix_lists;
}
}*/
 //-------------------------------------------------------------------------------
//#endif
/*
//only use for verification : cost of synchronizations
//-------------------------------------------------------------------------------
void Mpiomp::print(std::string str)
//-------------------------------------------------------------------------------
{
   std::stringstream st2;
     #ifdef _OPENMP
     st2<<"\nMPI "<<Mpiomp::mpi_rank<<" - Proc "<<omp_get_thread_num()<<" : "<<str;
     #else
     st2<<"\nMPI "<<Mpiomp::mpi_rank<<" - "<<" : "<<str;
     #endif

  #ifdef _OPENMP
    #pragma omp critical
    {
    #endif
      mkdir("outputs", 01777);
      std::stringstream fileStr;
      fileStr<<"./outputs/log_mach"<<Mpiomp::mpi_rank<<".txt";
      std::ofstream fileW(fileStr.str().data(),std::ios_base::app);
      fileW.write(st2.str().data(),st2.str().size());
      fileW.close();
  #ifdef _OPENMP
    }
    #endif
  }
//-------------------------------------------------------------------------------

//-------------------------------------------------------------------------------
void Mpiomp::printScreen(std::string str)
//-------------------------------------------------------------------------------
{
   std::stringstream st2;
     #ifdef _OPENMP
     st2<<"MPI "<<Mpiomp::mpi_rank<<" - Proc "<<omp_get_thread_num()<<" : "<<str;
     #else
     st2<<"MPI "<<Mpiomp::mpi_rank<<" - "<<" : "<<str;
     #endif

  #ifdef _OPENMP
    #pragma omp critical
    {
    #endif
      std::cout<<st2.str()<<std::endl;
  #ifdef _OPENMP
    }
    #endif
  }
//-------------------------------------------------------------------------------
*/
#endif

