#include "vtk_out.hpp"

vtk_out::vtk_out(parameters * &par):output(par) {
    /*cout << "************************************************************************" << endl;
    cout << "Output vtk DataFile"<< endl;
    cout << "************************************************************************" << endl;*/
    count=1;
}

void vtk_out::write(TAB & h,TAB & u,TAB & v,TAB & z, SCALAR tps) {
    char time_saved[NB_CHAR];
    char ncount[NB_CHAR];
    char mpi[NB_CHAR];
    sprintf(mpi,"%d",Mpiomp::mpi_rank);
    sprintf(time_saved,"%f",tps);
    sprintf(ncount,"%d",count);
    //cout << endl;
    //cout << endl;
    //cout << "# time : "<< time_saved  << " seconds "<<endl;
    //cout << "File number =" << ncount << endl;
    string namefile_copy = namefile; /*Permit to have the name file huz_evolutionxxx.vtk with xxx the number of time saved  */
    namefile_copy +="_";
    namefile_copy +=mpi;
    namefile_copy +="_";
    namefile_copy +=ncount;
    namefile_copy += ".vtk";

    ofstream sortie(namefile_copy.c_str(),ios::out);
    if (!sortie) {
        cout << "Impossible to open the " << namefile_copy.c_str() <<" file\n";
        cout << "Verify if the directory " << outputDirectory <<" exists\n";
        exit(-1);
    }

    unsigned int width = h->getWidth();
    unsigned int height = h->getHeight();

    sortie << "# vtk DataFile Version 2.0"  << endl;
    sortie << "Generated by FullSWOF_2D"  << endl;
    sortie << "ASCII"  << endl;
    sortie << "DATASET RECTILINEAR_GRID"  << endl;
    sortie << "DIMENSIONS " << width+1 << " " << height+1 <<" 1"  << endl;
    sortie << "X_COORDINATES "<< width+1 << " " << "float" << endl;

    SCALAR x0 = h->getX();
    SCALAR y0 = h->getY();

    for(int i=0; i<width+1; i++) {
        sortie << x0+i*dx << " ";
    }
    sortie << endl;

    sortie << "Y_COORDINATES "<< height+1 << " " << "float" << endl;
    for(int j=0; j<height+1; j++) {
        sortie << y0-j*dx << " ";
    }
    sortie << endl;
    sortie << "Z_COORDINATES "<< 1 << " " << "float" << endl;
    sortie << 0. << endl;
    sortie << endl;

    sortie << "CELL_DATA " << width*height << endl;

    sortie << "SCALARS z double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    iTAB it = z->begin();
    iTAB itEnd = z->end();
    for(; it<=itEnd; ++it)
        sortie << z->getValue(it) << endl;

    sortie  << endl;

    sortie << "SCALARS h double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    it = h->begin();
    itEnd = h->end();
    for(; it<=itEnd; ++it)
        sortie << h->getValue(it) << endl;

    sortie  << endl;

    sortie << "SCALARS h+z double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    it = h->begin();
    itEnd = h->end();
    for(; it<=itEnd; ++it)
        sortie <<   h->getValue(it)+z->getValue(it) << " " ;

    sortie  << endl;

    sortie << "SCALARS u double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    it = u->begin();
    itEnd = u->end();
    for(; it<=itEnd; ++it)
        sortie << u->getValue(it) << endl;

    sortie  << endl;

    sortie << "SCALARS v double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    it = v->begin();
    itEnd = v->end();
    for(; it<=itEnd; ++it)
        sortie << v->getValue(it) << endl;

    sortie  << endl;

    sortie << "VECTORS U float" << endl;
    it = u->begin();
    itEnd = u->end();
    for(; it<=itEnd; ++it)
        sortie << u->getValue(it) << " " << v->getValue(it) << " " << 0. << endl;

    sortie  << endl;

    sortie << "SCALARS norm_U double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    it = u->begin();
    itEnd = u->end();
    for(; it<=itEnd; ++it)
        sortie << sqrt(pow(u->getValue(it),2)+pow(v->getValue(it),2))   << " " ;

    sortie  << endl;

    sortie << "SCALARS q double 1"  << endl;
    sortie << "LOOKUP_TABLE default"  << endl;
    it = u->begin();
    itEnd = u->end();
    for(; it<=itEnd; ++it)
        sortie <<  h->getValue(it)*sqrt(pow(u->getValue(it),2)+pow(v->getValue(it),2))  << " " ;

    count++;
}


vtk_out::~vtk_out() {}

