#include "misc.hpp"
#include "order2.hpp"
#include "order2_parallel.hpp"

order2::order2(parameters * &par):scheme(par) {

    // variable avec cellule fictive
    hsa = new DMatrix<SCALAR>(head,ORDER,0);
    usa = new DMatrix<SCALAR>(head,ORDER,0);
    vsa = new DMatrix<SCALAR>(head,ORDER,0);

    // variable sans cellule fictive
    qsa1 = new DMatrix<SCALAR>(head,0,0);
    qsa2 = new DMatrix<SCALAR>(head,0,0);

    // variable a l'interface en x
    z1l = new DMatrix<SCALAR>(head2,0,0);
    z1r = new DMatrix<SCALAR>(head2,0,0);

    // variable a l'interface en y
    z2l = new DMatrix<SCALAR>(head3,0,0);
    z2r = new DMatrix<SCALAR>(head3,0,0);

    rec = rec_muscl::getSingleton(par->get_lim());

}

order2::~order2() {

    delete hsa;
    delete usa;
    delete vsa;
    delete qsa1;
    delete qsa2;
    delete z1l;
    delete z1r;
    delete z2l;
    delete z2r;

    if (rec != NULL) {
        delete rec;
        rec = NULL;
    }

}

void order2:: Heun_hq(TAB & he, TAB & qe1, TAB & qe2, TAB & hes, TAB & qes1, TAB & qes2) {

    vTAB inputs, outputs;
    outputs.push_back(he);
    outputs.push_back(qe1);
    outputs.push_back(qe2);
    outputs.push_back(hes);
    outputs.push_back(qes1);
    outputs.push_back(qes2);

    applyList<SCALAR,SCALAR>(Heun_hq_f,inputs,outputs);
}

void order2::calcul() {

    //time iteration's beginning
    Chronometer chrono;
    chrono.start();
    while (T > tps) {
        // save the data in huv_movie.dat
        //if (n % nsave == 0) {
       //      out->write(h,u,v,z,tps);
       //  }// end if

        //boundary conditions
        boundary(h,u,v);

        vTAB inputs, outputs;

        inputs.push_back(h);
        inputs.push_back(u);
        inputs.push_back(v);
        inputs.push_back(z);
        outputs.push_back(h1l);
        outputs.push_back(h1r);
        outputs.push_back(u1l);
        outputs.push_back(u1r);
        outputs.push_back(v1l);
        outputs.push_back(v1r);
        outputs.push_back(z1l);
        outputs.push_back(z1r);

        applyList<SCALAR,SCALAR>(order2_huv1_f,inputs,outputs);

        outputs.clear();
        outputs.push_back(h2l);
        outputs.push_back(h2r);
        outputs.push_back(u2l);
        outputs.push_back(u2r);
        outputs.push_back(v2l);
        outputs.push_back(v2r);
        outputs.push_back(z2l);
        outputs.push_back(z2r);

        applyList<SCALAR,SCALAR>(order2_huv2_f,inputs,outputs);

        inputs.clear();
        outputs.clear();

        //------------delz1,delz2,delzc1,delzc2------------//
        //delz1
        apply<SCALAR,SCALAR,SCALAR>(order2_delz_f,z1l,z1r,delz1);
        //delzc1
        apply<SCALAR,SCALAR,SCALAR>(order2_delzc1_f,z1l,z1r,delzc1);
        //delz2
        apply<SCALAR,SCALAR,SCALAR>(order2_delz_f,z2l,z2r,delz2);
        //delzc1
        apply<SCALAR,SCALAR,SCALAR>(order2_delzc2_f,z2l,z2r,delzc2);
        //-------------------------------------------------//

        bloc1(flux_left,flux_right,flux_bottom,flux_top);

        bloc2(h,u,v,q1,q2,hs,qs1,qs2);

        check_ve_ca(hs,us,vs,qs1,qs2);
        //----------------------------------------------//

        //boundary conditions
        boundary(hs,us,vs);

        inputs.push_back(hs);
        inputs.push_back(us);
        inputs.push_back(vs);
        inputs.push_back(z);
        outputs.push_back(h1l);
        outputs.push_back(h1r);
        outputs.push_back(u1l);
        outputs.push_back(u1r);
        outputs.push_back(v1l);
        outputs.push_back(v1r);
        outputs.push_back(z1l);
        outputs.push_back(z1r);

        applyList<SCALAR,SCALAR>(order2_huv1_f,inputs,outputs);

        outputs.clear();
        outputs.push_back(h2l);
        outputs.push_back(h2r);
        outputs.push_back(u2l);
        outputs.push_back(u2r);
        outputs.push_back(v2l);
        outputs.push_back(v2r);
        outputs.push_back(z2l);
        outputs.push_back(z2r);

        applyList<SCALAR,SCALAR>(order2_huv2_f,inputs,outputs);

        inputs.clear();
        outputs.clear();

        //------------delz1,delz2,delzc1,delzc2------------//
        //delz1
        apply<SCALAR,SCALAR,SCALAR>(order2_delz_f,z1l,z1r,delz1);
        //delzc1
        apply<SCALAR,SCALAR,SCALAR>(order2_delzc1_f,z1l,z1r,delzc1);
        //delz2
        apply<SCALAR,SCALAR,SCALAR>(order2_delz_f,z2l,z2r,delz2);
        //delzc1
        apply<SCALAR,SCALAR,SCALAR>(order2_delzc2_f,z2l,z2r,delzc2);
        //-------------------------------------------------//


        bloc1(flux_left,flux_right,flux_bottom,flux_top);

        bloc2(hs,us,vs,qs1,qs2,hsa,qsa1,qsa2);

        //----------------------------------------------//
        Heun_hq(h,q1,q2,hsa,qsa1,qsa2);
        check_ve_ca(h,u,v,q1,q2);

        tps += dt;
        n++;

    } //end for n : loop in time

   // out->write(h,u,v,z,tps);

    chrono.stop();
    std::stringstream st;
    st<<" Time TOTAL CALCULATION : "<<chrono.dureeCalcule()<<" ";
    Mpiomp::printScreen(st.str());


}
