#include "scheme.hpp"
#include "scheme_parallel.hpp"

scheme::scheme(parameters * & par) {
    Nxcell = par->get_Nxcell();
    Nycell = par->get_Nycell();
    ORDER = par->get_order();
    T = par->get_T();
    dt=  par->get_dtfix();
    dx = par->get_dx();
    dy = par->get_dy();
    nsave = par->get_nsave();


    allocation(par);

    flux_num = choice_flux::getSingleton(par->get_flux());
    rec_hydro = hydrostatic::getSingleton();
    Lbound = choice_condition_left::getSingleton(par->get_Lbound());
    Rbound = choice_condition_right::getSingleton(par->get_Rbound());
    Bbound = choice_condition_bottom::getSingleton(par->get_Bbound());
    Tbound = choice_condition_top::getSingleton(par->get_Tbound());
//    fric = new choice_friction::getSingleton(par);
//   Prain = new ChoiceRain(par);
//   I = new choice_infiltration(par);
    out = choice_output::getSingleton();

    tps=0;
    n = 0;
    apply<SCALAR,SCALAR>(boundaryz_f,z,z,false);

    /*
        Vol_inf = 0.;
        Vol_rain = 0.;
        Vol_left = 0.;
        Vol_right = 0.;
        Vol_bottom = 0.;
        Vol_top = 0.;
       */
    flux_left = 0.;
    flux_right = 0.;
    flux_top = 0.;
    flux_bottom = 0.;

}

scheme::~scheme() {
    desallocation();
}

void scheme:: bloc1(SCALAR & flux_left_tmp, SCALAR & flux_right_tmp, SCALAR & flux_bottom_tmp, SCALAR & flux_top_tmp) {
    vTAB inputs, outputs;
    inputs.push_back(h1l);
    inputs.push_back(h1r);
    inputs.push_back(u1l);
    inputs.push_back(u1r);
    inputs.push_back(v1l);
    inputs.push_back(v1r);
    inputs.push_back(delz1);
    outputs.push_back(h1g);
    outputs.push_back(h1d);
    outputs.push_back(f1);
    outputs.push_back(f2);
    outputs.push_back(f3);
    applyList<SCALAR,SCALAR>(bloc1x_f,inputs,outputs);

    inputs.clear();
    outputs.clear();
    inputs.push_back(h2l);
    inputs.push_back(h2r);
    inputs.push_back(u2l);
    inputs.push_back(u2r);
    inputs.push_back(v2l);
    inputs.push_back(v2r);
    inputs.push_back(delz2);
    outputs.push_back(h2g);
    outputs.push_back(h2d);
    outputs.push_back(g1);
    outputs.push_back(g2);
    outputs.push_back(g3);
    applyList<SCALAR,SCALAR>(bloc1y_f,inputs,outputs);

    /*
        flux_left_tmp = 0.;
        flux_right_tmp = 0.;
        for (int l=1; l<Nycell+1; l++) {
            flux_left_tmp +=  f1[1][l];
            flux_right_tmp +=  f1[Nxcell+1][l];
        }
        flux_left_tmp /= Nycell*dy;
        flux_right_tmp /= Nycell*dy;

        flux_bottom_tmp = 0.;
        flux_top_tmp = 0.;
        for (int i=1 ; i<Nxcell+1 ; i++) {
            flux_bottom_tmp +=  g1[i][1];
            flux_top_tmp +=  g1[i][Nycell+1];
        }
        flux_top_tmp /=  Nxcell*dx;
        flux_bottom_tmp /=  Nxcell*dx;
        */
}

void scheme:: bloc2(TAB & he, TAB & ve1, TAB & ve2, TAB & qe1, TAB & qe2, TAB & hes, TAB & qes1, TAB & qes2) {
    vTAB inputs, outputs;
    inputs.push_back(he);
    inputs.push_back(ve1);
    inputs.push_back(ve2);
    inputs.push_back(qe1);
    inputs.push_back(qe2);
    inputs.push_back(h1l);
    inputs.push_back(h1r);
    inputs.push_back(h1g);
    inputs.push_back(h1d);
    inputs.push_back(h2l);
    inputs.push_back(h2r);
    inputs.push_back(h2g);
    inputs.push_back(h2d);
    inputs.push_back(delzc1);
    inputs.push_back(delzc2);
    inputs.push_back(f1);
    inputs.push_back(f2);
    inputs.push_back(f3);
    inputs.push_back(g1);
    inputs.push_back(g2);
    inputs.push_back(g3);

    outputs.push_back(hes);
    outputs.push_back(qes1);
    outputs.push_back(qes2);

    applyList<SCALAR,SCALAR>(bloc2_f,inputs,outputs);
}

void scheme:: update_hq(TAB & he, TAB & qe1, TAB & qe2, TAB & hes, TAB & qes1, TAB & qes2) {

    vTAB inputs, outputs;
    outputs.push_back(he);
    outputs.push_back(qe1);
    outputs.push_back(qe2);
    outputs.push_back(hes);
    outputs.push_back(qes1);
    outputs.push_back(qes2);

    applyList<SCALAR,SCALAR>(update_hq_f,inputs,outputs);
}

void scheme:: boundary(TAB & he,TAB & ve1 ,TAB & ve2) {

    vTAB inputs, outputs;
    outputs.push_back(he);
    outputs.push_back(ve1);
    outputs.push_back(ve2);

    applyList<SCALAR,SCALAR>(boundary_f,inputs,outputs);
}

void scheme:: check_ve_ca(TAB & he, TAB & ve1, TAB & ve2, TAB & qe1, TAB & qe2) {

    vTAB inputs, outputs;
    outputs.push_back(he);
    outputs.push_back(ve1);
    outputs.push_back(ve2);
    outputs.push_back(qe1);
    outputs.push_back(qe2);

    applyList<SCALAR,SCALAR>(ve_ca_f,inputs,outputs);
}

void scheme::allocation(parameters * & par) {
    //HEADER head;
    head.width = Nxcell;
    head.height = Nycell;
    head.x = 0;
    head.y = 0;
    head.spacing = dx;
    head.nodata = -9999;

    // variable avec cellule fictive
    if(par->get_h()==1) {
        h = new DMatrix<SCALAR>((par->get_hNameFile()).data(),ORDER);
    } else {
        h = new DMatrix<SCALAR>(head,ORDER,0.);
    }
    if(par->get_topo()==1) {
        z = new DMatrix<SCALAR>((par->get_topographyNameFile()).data(),ORDER);
    } else {
        z = new DMatrix<SCALAR>(head,ORDER,0.);
    }

    u = new DMatrix<SCALAR>(head,ORDER,0.);
    v = new DMatrix<SCALAR>(head,ORDER,0.);

    hs = new DMatrix<SCALAR>(head,ORDER,0.);
    us = new DMatrix<SCALAR>(head,ORDER,0.);
    vs = new DMatrix<SCALAR>(head,ORDER,0.);

    // variable sans cellule fictive

    q1 = new DMatrix<SCALAR>(head,0,0);
    q2 = new DMatrix<SCALAR>(head,0,0);
    qs1 = new DMatrix<SCALAR>(head,0,0);
    qs2 = new DMatrix<SCALAR>(head,0,0);
    delzc1 = new DMatrix<SCALAR>(head,0,0);
    delzc2 = new DMatrix<SCALAR>(head,0,0);

    // variable a l'interface en x
    //HEADER head2;
    head2.width = head.width+1;
    head2.height = head.height;
    head2.x = head.x;
    head2.y = head.y;
    head2.spacing = head.spacing;
    head2.nodata = head.nodata;
    f1 = new DMatrix<SCALAR>(head2,0,0);
    f2 = new DMatrix<SCALAR>(head2,0,0);
    f3 = new DMatrix<SCALAR>(head2,0,0);
    h1g = new DMatrix<SCALAR>(head2,0,0);
    h1l = new DMatrix<SCALAR>(head2,0,0);
    u1l = new DMatrix<SCALAR>(head2,0,0);
    v1l = new DMatrix<SCALAR>(head2,0,0);
    h1d = new DMatrix<SCALAR>(head2,0,0);
    h1r = new DMatrix<SCALAR>(head2,0,0);
    u1r = new DMatrix<SCALAR>(head2,0,0);
    v1r = new DMatrix<SCALAR>(head2,0,0);
    delz1 = new DMatrix<SCALAR>(head2,0,0);

    // variable a l'interface en y
    //HEADER head3;
    head3.width = head.width;
    head3.height = head.height+1;
    head3.x = head.x;
    head3.y = head.y;
    head3.spacing = head.spacing;
    head3.nodata = head.nodata;
    g1 = new DMatrix<SCALAR>(head3,0,0);
    g2 = new DMatrix<SCALAR>(head3,0,0);
    g3 = new DMatrix<SCALAR>(head3,0,0);
    h2g = new DMatrix<SCALAR>(head3,0,0);
    h2l = new DMatrix<SCALAR>(head3,0,0);
    u2l = new DMatrix<SCALAR>(head3,0,0);
    v2l = new DMatrix<SCALAR>(head3,0,0);
    h2d = new DMatrix<SCALAR>(head3,0,0);
    h2r = new DMatrix<SCALAR>(head3,0,0);
    u2r = new DMatrix<SCALAR>(head3,0,0);
    v2r = new DMatrix<SCALAR>(head3,0,0);
    delz2 = new DMatrix<SCALAR>(head3,0,0);
}

void scheme::desallocation() {
    delete Lbound;
    delete Rbound;
    delete Bbound;
    delete Tbound;
    delete flux_num;
    delete rec_hydro;

//delete Prain ;
//delete topo;
//delete huv_init;

//delete fric;
//delete I;
    delete out;
    delete z;
    delete h;
    delete u;
    delete v;
    delete q1;
    delete q2;
    delete hs;
    delete us;
    delete vs;
    delete qs1;
    delete qs2;
    delete f1;
    delete f2;
    delete f3;
    delete g1;
    delete g2;
    delete g3;
    delete h1g;
    delete h1l;
    delete u1l;
    delete v1l;
    delete h1d;
    delete h1r;
    delete u1r;
    delete v1r;
    delete h2g;
    delete h2l;
    delete u2l;
    delete v2l;
    delete h2d;
    delete h2r;
    delete u2r;
    delete v2r;
    delete delz1;
    delete delz2;
    delete delzc1;
    delete delzc2;
}
